<?php $__env->startSection('page-title'); ?>
    <?php echo e(__('Manage Bills')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('breadcrumb'); ?>
    <?php if(\Auth::guard('vender')->check()): ?>
        <li class="breadcrumb-item"><a href="<?php echo e(route('vender.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a></li>
    <?php else: ?>
        <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a></li>
    <?php endif; ?>

    <li class="breadcrumb-item"><?php echo e(__('Bill')); ?></li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('action-btn'); ?>
    <div class="d-flex">

        <a href="<?php echo e(route('Bill.export')); ?>" class="btn btn-sm btn-primary me-2" data-bs-toggle="tooltip"
            title="<?php echo e(__('Export')); ?>">
            <i class="ti ti-file-export"></i>
        </a>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create bill')): ?>
            <a href="<?php echo e(route('bill.create', 0)); ?>" class="btn btn-sm btn-primary" data-bs-toggle="tooltip"
                title="<?php echo e(__('Create')); ?>">
                <i class="ti ti-plus"></i>
            </a>
        <?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>
    <?php

    ?>
    <div class="row">
        <div class="col-sm-12">
            <div class=" multi-collapse mt-2" id="multiCollapseExample1">
                <div class="card">
                    <div class="card-body">
                        <?php if(!\Auth::guard('vender')->check()): ?>
                            <?php echo e(Form::open(['route' => ['bill.index'], 'method' => 'GET', 'id' => 'frm_submit'])); ?>

                        <?php else: ?>
                            <?php echo e(Form::open(['route' => ['vender.bill'], 'method' => 'GET', 'id' => 'frm_submit'])); ?>

                        <?php endif; ?>
                        <div class="row d-flex align-items-center justify-content-end">
                            <div class="col-xl-3 col-lg-3 col-md-6 col-sm-12 col-12 mr-2">
                                <div class="btn-box">
                                    <?php echo e(Form::label('date', __('Date'),['class'=>'text-type'])); ?>

                                    <?php echo e(Form::date('bill_date', isset($_GET['bill_date']) ? $_GET['bill_date'] : '', ['class' => 'month-btn form-control', 'id' => 'pc-daterangepicker-1', 'placeholder' => 'YYYY-MM-DD'])); ?>


                                </div>
                            </div>
                            <?php if(!\Auth::guard('vender')->check()): ?>
                                <div class="col-xl-3 col-lg-3 col-md-6 col-sm-12 col-12 mr-2">
                                    <div class="btn-box">
                                        <?php echo e(Form::label('vender', __('Vender'),['class'=>'text-type'])); ?>

                                        <?php echo e(Form::select('vender', $vender, isset($_GET['vender']) ? $_GET['vender'] : '', ['class' => 'form-control'])); ?>

                                    </div>
                                </div>
                            <?php endif; ?>
                            <div class="col-xl-3 col-lg-3 col-md-6 col-sm-12 col-12">
                                <div class="btn-box">
                                    <?php echo e(Form::label('status', __('Status'),['class'=>'text-type'])); ?>

                                    <?php echo e(Form::select('status', ['' => 'Select Status'] + $status, isset($_GET['status']) ? $_GET['status'] : '', ['class' => 'form-control'])); ?>

                                </div>
                            </div>
                            <div class="col-auto d-flex ms-2 mt-3">
                                <a href="#" class="btn btn-sm btn-primary me-2"
                                    onclick="document.getElementById('frm_submit').submit(); return false;"
                                    data-bs-toggle="tooltip" title="<?php echo e(__('Apply')); ?>"
                                    data-original-title="<?php echo e(__('Apply')); ?>">
                                    <span class="btn-inner--icon"><i class="ti ti-search"></i></span>
                                </a>

                                <?php if(!\Auth::guard('vender')->check()): ?>
                                    <a href="<?php echo e(route('bill.index')); ?>" class="btn btn-sm btn-danger"
                                        data-bs-toggle="tooltip" title="<?php echo e(__('Reset')); ?>"
                                        data-original-title="<?php echo e(__('Reset')); ?>">
                                        <span class="btn-inner--icon"><i class="ti ti-refresh text-white-off"></i></span>
                                    </a>
                                <?php else: ?>
                                    <a href="<?php echo e(route('vender.bill')); ?>" class="btn btn-sm btn-danger"
                                        data-bs-toggle="tooltip" title="<?php echo e(__('Reset')); ?>"
                                        data-original-title="<?php echo e(__('Reset')); ?>">
                                        <span class="btn-inner--icon"><i class="ti ti-refresh text-white-off"></i></span>
                                    </a>
                                <?php endif; ?>
                            </div>

                        </div>
                        <?php echo e(Form::close()); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body table-border-style">
                    <div class="table-responsive">
                        <table class="table datatable">
                            <thead>
                                <tr>
                                    <th> <?php echo e(__('Bill')); ?></th>
                                    <?php if(!\Auth::guard('vender')->check()): ?>
                                        <th> <?php echo e(__('Vendor')); ?></th>
                                    <?php endif; ?>
                                    <th> <?php echo e(__('Category')); ?></th>
                                    <th> <?php echo e(__('Bill Date')); ?></th>
                                    <th> <?php echo e(__('Due Date')); ?></th>
                                    <th><?php echo e(__('Status')); ?></th>
                                    <?php if(Gate::check('edit bill') || Gate::check('delete bill') || Gate::check('show bill')): ?>
                                        <th width="10%"> <?php echo e(__('Action')); ?></th>
                                    <?php endif; ?>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $bills; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bill): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td class="Id">
                                            <?php if(\Auth::guard('vender')->check()): ?>
                                                <a href="<?php echo e(route('vender.bill.show', \Crypt::encrypt($bill->id))); ?>"
                                                    class="btn btn-outline-primary"><?php echo e(AUth::user()->billNumberFormat($bill->bill_id)); ?></a>
                                            <?php else: ?>
                                                <a href="<?php echo e(route('bill.show', \Crypt::encrypt($bill->id))); ?>"
                                                    class="btn btn-outline-primary"><?php echo e(AUth::user()->billNumberFormat($bill->bill_id)); ?></a>
                                            <?php endif; ?>
                                        </td>
                                        <?php if(!\Auth::guard('vender')->check()): ?>
                                            <td> <?php echo e(!empty($bill->vender) ? $bill->vender->name : ''); ?> </td>
                                        <?php endif; ?>
                                        <td><?php echo e(!empty($bill->category) ? $bill->category->name : ''); ?></td>
                                        <td><?php echo e(Auth::user()->dateFormat($bill->bill_date)); ?></td>
                                        <td><?php echo e(Auth::user()->dateFormat($bill->due_date)); ?></td>
                                        <td>
                                            <?php if($bill->status == 0): ?>
                                                <span
                                                    class="badge fix_badges bg-secondary p-2 px-3 "><?php echo e(__(\App\Models\Invoice::$statues[$bill->status])); ?></span>
                                            <?php elseif($bill->status == 1): ?>
                                                <span
                                                    class="badge fix_badges bg-warning p-2 px-3 "><?php echo e(__(\App\Models\Invoice::$statues[$bill->status])); ?></span>
                                            <?php elseif($bill->status == 2): ?>
                                                <span
                                                    class="badge fix_badges bg-danger p-2 px-3 "><?php echo e(__(\App\Models\Invoice::$statues[$bill->status])); ?></span>
                                            <?php elseif($bill->status == 3): ?>
                                                <span
                                                    class="badge fix_badges bg-info p-2 px-3 "><?php echo e(__(\App\Models\Invoice::$statues[$bill->status])); ?></span>
                                            <?php elseif($bill->status == 4): ?>
                                                <span
                                                    class="badge fix_badges bg-primary p-2 px-3 "><?php echo e(__(\App\Models\Invoice::$statues[$bill->status])); ?></span>
                                            <?php endif; ?>
                                        </td>
                                        <?php if(Gate::check('edit bill') || Gate::check('delete bill') || Gate::check('show bill')): ?>
                                            <td class="Action">
                                                <span>
                                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('duplicate bill')): ?>
                                                        <div class="action-btn me-2">
                                                            <?php echo Form::open([
                                                                'method' => 'get',
                                                                'route' => ['bill.duplicate', $bill->id],
                                                                'id' => 'duplicate-form-' . $bill->id,
                                                            ]); ?>


                                                            <a href="#"
                                                                class="mx-3 btn btn-sm align-items-center bs-pass-para bg-secondary "
                                                                data-bs-toggle="tooltip"
                                                                data-original-title="<?php echo e(__('Duplicate')); ?>"
                                                                data-bs-toggle="tooltip" title="<?php echo e(__('Duplicate Bill')); ?>"
                                                                data-original-title="<?php echo e(__('Delete')); ?>"
                                                                data-confirm="You want to confirm this action. Press Yes to continue or Cancel to go back"
                                                                data-confirm-yes="document.getElementById('duplicate-form-<?php echo e($bill->id); ?>').submit();">
                                                                <i class="ti ti-copy text-white"></i>
                                                                <?php echo Form::close(); ?>

                                                            </a>
                                                        </div>
                                                    <?php endif; ?>
                                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('show bill')): ?>
                                                        <?php if(\Auth::guard('vender')->check()): ?>
                                                            <div class="action-btn me-2">
                                                                <a href="<?php echo e(route('vender.bill.show', \Crypt::encrypt($bill->id))); ?>"
                                                                    class="mx-3 btn btn-sm align-items-center bg-warning"
                                                                    data-bs-toggle="tooltip" title="<?php echo e(__('Show')); ?>"
                                                                    data-original-title="<?php echo e(__('Detail')); ?>">
                                                                    <i class="ti ti-eye text-white"></i>
                                                                </a>
                                                            </div>
                                                        <?php else: ?>
                                                            <div class="action-btn me-2">
                                                                <a href="<?php echo e(route('bill.show', \Crypt::encrypt($bill->id))); ?>"
                                                                    class="mx-3 btn btn-sm align-items-center bg-warning "
                                                                    data-bs-toggle="tooltip" title="<?php echo e(__('Show')); ?>"
                                                                    data-original-title="<?php echo e(__('Detail')); ?>">
                                                                    <i class="ti ti-eye text-white"></i>
                                                                </a>
                                                            </div>
                                                        <?php endif; ?>
                                                    <?php endif; ?>
                                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('edit bill')): ?>
                                                        <div class="action-btn me-2">
                                                            <a href="<?php echo e(route('bill.edit', \Crypt::encrypt($bill->id))); ?>"
                                                                class="mx-3 btn btn-sm align-items-center bg-info"
                                                                data-bs-toggle="tooltip" title="Edit"
                                                                data-original-title="<?php echo e(__('Edit')); ?>">
                                                                <i class="ti ti-pencil text-white"></i>
                                                            </a>
                                                        </div>
                                                    <?php endif; ?>
                                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete bill')): ?>
                                                        <div class="action-btn">

                                                            <?php echo Form::open(['method' => 'DELETE', 'route' => ['bill.destroy', $bill->id]]); ?>

                                                            <a href="#"
                                                                class="mx-3 btn btn-sm align-items-center bs-pass-para bg-danger "
                                                                data-bs-toggle="tooltip" title="<?php echo e(__('Delete')); ?>"
                                                                data-original-title="<?php echo e(__('Delete')); ?>">
                                                                <i class="ti ti-trash text-white"></i>
                                                            </a>
                                                            <?php echo Form::close(); ?>

                                                        </div>
                                                    <?php endif; ?>
                                                </span>
                                            </td>
                                        <?php endif; ?>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/accountgo/accountGo_v11/accountgo-saas/main_file/resources/views/bill/index.blade.php ENDPATH**/ ?>